#include <p30fxxxx.h>
#include <spi.h>

/********************************************************************
*     Function Name : DataRdySPI2                                   *
*     Description   : Determine if there is a byte/word to be read  *
*                     from the SPIBUF register.                     *
*     Parameters    : None                                          *
*     Return Value  : status bit to indicate if RBF = 1 else 0      *
********************************************************************/

/* The following devices support SPI2 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__)  || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) ||  defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)   

char DataRdySPI2()
{   
    return SPI2STATbits.SPIRBF; /* return RBF bit status */
}

#endif
